import sys

import numpy as np

file_name = sys.argv[1]
accel_data = []
gyro_data = []
with open(f"{file_name}.txt") as f:
    lines = f.readlines()

    print(len(lines), "in total.")

    for i, l in enumerate(lines):
        l_split = np.array(l[:-1].split(" "))
        for ai in range(len(l_split)):
            if l_split[ai] == "Acceleration":
                accel_data.append(
                    [
                        l_split[ai + 2].astype(np.float32),
                        l_split[ai + 3].astype(np.float32),
                        l_split[ai + 4].astype(np.float32),
                    ]
                )
            if l_split[ai] == "Gyro":
                gyro_data.append(
                    [
                        l_split[ai + 2].astype(np.float32),
                        l_split[ai + 3].astype(np.float32),
                        l_split[ai + 4].astype(np.float32),
                    ]
                )


print(len(accel_data))
print(len(gyro_data))
np.savetxt(f"{file_name}_accel.csv", accel_data, delimiter=",")
np.savetxt(f"{file_name}_gyro.csv", gyro_data, delimiter=",")
