/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.OutputListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class OutputHandler
extends Thread {
    InputStream sourceStream;
    Vector listeners;
    private boolean ignoreStreamEnd;

    public OutputHandler(InputStream inputStream) {
        this.sourceStream = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        this.listeners = new Vector();
        this.ignoreStreamEnd = false;
    }

    public synchronized void addOutputListener(OutputListener outputListener) {
        this.listeners.addElement(outputListener);
    }

    public synchronized void removeOutputListener(OutputListener outputListener) {
        this.listeners.removeElement(outputListener);
    }

    public boolean hasListener(OutputListener outputListener) {
        return this.listeners.contains(outputListener);
    }

    public void run() {
        byte[] byArray = new byte[1024];
        try {
            while (true) {
                int n;
                if ((n = this.sourceStream.read(byArray, 0, byArray.length)) == -1) {
                    this.fireStreamEnded();
                    break;
                }
                this.fireABs(byArray, n);
            }
        }
        catch (IOException iOException) {
            throw new IPException("Problem fetching output:" + iOException);
        }
    }

    synchronized void fireStreamEnded() {
        if (this.ignoreStreamEnd) {
            return;
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ((OutputListener)this.listeners.elementAt(n)).streamEnded();
            ++n;
        }
    }

    synchronized void fireABs(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((OutputListener)this.listeners.elementAt(n2)).analyseBytes(byArray, n);
            ++n2;
        }
    }

    public void setIgnoreStreamEnd(boolean bl) {
        this.ignoreStreamEnd = bl;
    }
}

