/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import com.declarativa.interprolog.util.GoalFromJava;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.ResultFromProlog;

public class GoalToExecute {
    private GoalFromJava goal;
    private ResultFromProlog result;
    private boolean executing;
    private boolean ended;
    private boolean firstGoalStatus = false;
    private Runnable todo = null;
    Thread callerThread;

    public GoalToExecute(GoalFromJava goalFromJava) {
        this(goalFromJava, Thread.currentThread());
    }

    public GoalToExecute(GoalFromJava goalFromJava, Thread thread) {
        this.goal = goalFromJava;
        this.result = null;
        this.ended = false;
        this.executing = false;
        this.callerThread = thread;
    }

    public Thread getCallerThread() {
        return this.callerThread;
    }

    public synchronized void executeInThread(Runnable runnable) {
        if (this.todo != null || !this.executing || this.result != null || this.hasEnded()) {
            System.err.println("bad");
            System.err.println("r==" + runnable);
            System.err.println("todo==" + this.todo);
            System.err.println("executing==" + this.executing);
            System.err.println("firstGoalStatus==" + this.firstGoalStatus);
            System.err.println("result==" + this.result);
            System.err.println("hasEnded()==" + this.hasEnded());
            throw new IPException("bad execute");
        }
        this.todo = runnable;
        this.notify();
    }

    public synchronized ResultFromProlog waitForResult() {
        if (this.ended) {
            return this.result;
        }
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new IPException("Unexpected:" + interruptedException);
            }
            if (this.result == null && this.todo == null) {
                throw new IPException("Inconsistency in GoalToExecute");
            }
            if (this.todo == null) continue;
            this.todo.run();
            this.todo = null;
        } while (this.result == null);
        return this.result;
    }

    public synchronized void setResult(ResultFromProlog resultFromProlog) {
        if (this.result != null || this.hasEnded() || this.todo != null) {
            throw new IPException("Inconsistency in GoalToExecute");
        }
        this.result = resultFromProlog;
        this.ended = true;
        this.notify();
    }

    public boolean wasInterrupted() {
        return this.hasEnded() && "interrupted".equals(this.result.error);
    }

    public boolean wasAborted() {
        return this.hasEnded() && "aborted".equals(this.result.error);
    }

    public synchronized void interrupt() {
        this.raiseError("interrupted");
    }

    public synchronized void abort() {
        this.raiseError("aborted");
    }

    private void raiseError(String string) {
        if (this.result == null) {
            this.result = new ResultFromProlog(-1, false, 0, null);
        }
        this.result.error = string;
        this.ended = true;
        this.notify();
    }

    public GoalFromJava getGoal() {
        return this.goal;
    }

    public void prologWasCalled() {
        if (this.executing) {
            throw new IPException("Bad use of prologWasCalled");
        }
        this.executing = true;
    }

    public boolean hasStarted() {
        return this.executing;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public int getTimestamp() {
        return this.goal.timestamp;
    }

    public void setFirstGoalStatus() {
        this.firstGoalStatus = true;
    }

    public boolean isFirstGoal() {
        return this.firstGoalStatus;
    }

    public String toString() {
        return "GTE's ResultFromProlog: timestamp==" + this.getTimestamp();
    }
}

