/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.gui;

import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.gui.PredicateTableModel;
import com.declarativa.interprolog.gui.TermListModel;
import com.declarativa.interprolog.gui.TermTreeModel;
import com.declarativa.interprolog.gui.XSBTableModel;
import com.declarativa.interprolog.util.IPException;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public abstract class ListenerWindow
extends JFrame
implements WindowListener {
    public JTextArea prologOutput;
    public JTextArea prologInput;
    JMenu historyMenu;
    JMenu fileMenu;
    Vector loadedFiles;
    private static int topLevelCount = 0;
    public PrologEngine engine = null;
    public static boolean debug = false;
    public static String prologStartCommand = null;
    static /* synthetic */ Class class$com$declarativa$interprolog$gui$ListenerWindow;

    public ListenerWindow(PrologEngine prologEngine) {
        this(prologEngine, true);
    }

    public ListenerWindow(PrologEngine prologEngine, boolean bl) {
        super("PrologEngine listener (Swing)");
        if (prologEngine == null) {
            throw new IPException("missing Prolog engine");
        }
        this.engine = prologEngine;
        this.engine.consultFromPackage("visualization", class$com$declarativa$interprolog$gui$ListenerWindow == null ? (class$com$declarativa$interprolog$gui$ListenerWindow = ListenerWindow.class$("com.declarativa.interprolog.gui.ListenerWindow")) : class$com$declarativa$interprolog$gui$ListenerWindow);
        this.engine.teachMoreObjects(ListenerWindow.guiExamples());
        if (this.engine == null) {
            this.dispose();
        } else {
            ++topLevelCount;
        }
        debug = this.engine.isDebug();
        this.loadedFiles = new Vector();
        this.constructWindowContents();
        this.constructMenu();
        this.addWindowListener(this);
        this.prologInput.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ListenerWindow.this.sendToProlog();
                    keyEvent.consume();
                }
            }
        });
        this.prologOutput.append("Welcome to an InterProlog/XSB top level\n" + prologEngine.getPrologVersion());
        if (bl) {
            this.show();
            this.focusInput();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
        this.engine.shutdown();
        if (--topLevelCount <= 0) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.prologInput.requestFocus();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public static ObjectExamplePair[] guiExamples() {
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[]{PredicateTableModel.example(), TermListModel.example(), TermTreeModel.example(), new ObjectExamplePair("ArrayOfTermTreeModel", (Object)new TermTreeModel[0]), XSBTableModel.example()};
        return objectExamplePairArray;
    }

    void constructWindowContents() {
        Font font = new Font("Courier", 0, 12);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.prologOutput = new JTextArea(20, 80);
        this.prologOutput.setFont(font);
        this.prologOutput.setEditable(false);
        this.prologOutput.setToolTipText("Here's Prolog console output");
        this.prologOutput.setLineWrap(true);
        this.prologOutput.setDoubleBuffered(true);
        JScrollPane jScrollPane = new JScrollPane();
        this.prologInput = new JTextArea(4, 80);
        this.prologInput.setFont(font);
        this.prologInput.setLineWrap(true);
        this.prologInput.setToolTipText("Prolog input, sent when you press enter. Drag and drop .P files here to reconsult them");
        jScrollPane.getViewport().add(this.prologInput);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.prologOutput);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, this.prologInput);
        container.add("Center", jSplitPane);
        this.setSize(600, 600);
        jSplitPane.setDividerLocation(500);
        this.validate();
        DropTargetListener dropTargetListener = new DropTargetListener(){

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                ListenerWindow.this.handlePrologInputDnD(dropTargetDropEvent);
            }

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }
        };
        new DropTarget(this.prologInput, dropTargetListener);
    }

    void handlePrologInputDnD(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            int n = dropTargetDropEvent.getDropAction();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                if (this.engine.isIdle()) {
                    Object object;
                    dropTargetDropEvent.acceptDrop(n);
                    final List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    boolean bl = true;
                    int n2 = 0;
                    while (n2 < list.size()) {
                        object = ((File)list.get(n2)).getName();
                        int n3 = ((String)object).lastIndexOf(46);
                        if (!((String)object).endsWith(".P")) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        this.errorMessage("All dragged files must be Prolog source files (with a .P extension)");
                    } else {
                        this.prologOutput.append("\nReconsulting " + (list.size() > 1 ? list.size() + " files...\n" : list.size() + " file...\n"));
                        object = new Runnable(){

                            public void run() {
                                boolean bl = false;
                                Toolkit.getDefaultToolkit().sync();
                                int n = 0;
                                while (n < list.size() && !bl) {
                                    File file = (File)list.get(n);
                                    if (!ListenerWindow.this.processDraggedFile(file)) {
                                        bl = true;
                                    }
                                    ++n;
                                }
                                if (bl) {
                                    ListenerWindow.this.prologOutput.append("...terminated with errors.\n");
                                } else {
                                    ListenerWindow.this.prologOutput.append("...done.\n");
                                }
                            }
                        };
                        SwingUtilities.invokeLater((Runnable)object);
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                    this.errorMessage("You can not consult files while Prolog is working");
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (Exception exception) {
            throw new IPException("Problem dropping:" + exception);
        }
    }

    public boolean processDraggedFile(File file) {
        if (this.successfulCommand("reconsult('" + file.getAbsolutePath() + "')")) {
            this.addToReloaders(file, "reconsult");
            return true;
        }
        this.errorMessage("Problems reconsulting " + file.getName());
        return false;
    }

    public void errorMessage(String string) {
        ListenerWindow.beep();
        JOptionPane.showMessageDialog(this, string, "Error", 0);
    }

    void constructMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.fileMenu = new JMenu("File");
        jMenuBar.add(this.fileMenu);
        ListenerWindow.addItemToMenu(this.fileMenu, "Reconsult...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenerWindow.this.reconsultFile();
            }
        });
        ListenerWindow.addItemToMenu(this.fileMenu, "Load dynamically...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenerWindow.this.load_dynFile();
            }
        });
        this.fileMenu.addSeparator();
        JMenu jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Engine debugging");
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenerWindow.this.engine.setDebug(jCheckBoxMenuItem.isSelected());
            }
        });
        ListenerWindow.addItemToMenu(jMenu, "See Object Specifications", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenerWindow.this.engine.command("showObjectVariables");
            }
        });
        ListenerWindow.addItemToMenu(jMenu, "Interrupt XSB", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListenerWindow.this.engine.interrupt();
            }
        });
        this.historyMenu = new JMenu("History", true);
        jMenuBar.add(this.historyMenu);
        this.historyMenu.addSeparator();
    }

    static void addItemToMenu(JMenu jMenu, String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
    }

    public abstract void sendToProlog();

    protected void addToHistory() {
        JMenuItem jMenuItem;
        String string = this.prologInput.getText();
        if (string.equals(";")) {
            return;
        }
        if (string.length() > 20) {
            jMenuItem = new JMenuItem(string.substring(0, 19) + "...");
            this.historyMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem(string.substring(0, string.length()));
            this.historyMenu.add(jMenuItem);
        }
        jMenuItem.addActionListener(new HistoryListener(this.prologInput, string));
    }

    void addToReloaders(File file, String string) {
        final LoadedFile loadedFile = new LoadedFile(file, string);
        if (!this.loadedFiles.contains(loadedFile)) {
            this.loadedFiles.addElement(loadedFile);
            ListenerWindow.addItemToMenu(this.fileMenu, file.getName(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListenerWindow.this.engine.command(loadedFile.method + "('" + loadedFile.file.getAbsolutePath() + "')");
                }
            });
        }
    }

    public boolean successfulCommand(String string) {
        try {
            return this.engine.command(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    void reconsultFile() {
        File file = null;
        FileDialog fileDialog = new FileDialog((Frame)this, "Reconsult file...");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            file = new File(string2, string);
            if (this.successfulCommand("reconsult('" + file.getAbsolutePath() + "')")) {
                this.addToReloaders(file, "reconsult");
            }
        }
    }

    void load_dynFile() {
        File file = null;
        FileDialog fileDialog = new FileDialog((Frame)this, "load_dyn file...");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string != null) {
            file = new File(string2, string);
            if (this.successfulCommand("load_dyn('" + file.getAbsolutePath() + "')")) {
                this.addToReloaders(file, "load_dyn");
            }
        }
    }

    public void focusInput() {
        this.prologInput.selectAll();
        this.prologInput.requestFocus();
    }

    public void scrollToBottom() {
        block2: {
            if (!this.prologOutput.isShowing()) break block2;
            this.prologOutput.setCaretPosition(this.prologOutput.getDocument().getEndPosition().getOffset() - 1);
            try {
                JScrollBar jScrollBar = ((JScrollPane)((JViewport)this.prologOutput.getParent()).getParent()).getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getMaximum());
                JScrollBar jScrollBar2 = ((JScrollPane)((JViewport)this.prologOutput.getParent()).getParent()).getHorizontalScrollBar();
                jScrollBar2.setValue(jScrollBar2.getMinimum());
            }
            catch (Exception exception) {}
        }
    }

    public static void commonMain(String[] stringArray) {
        int n;
        ListenerWindow.commonGreeting();
        if (stringArray.length >= 1) {
            n = 0;
            while (stringArray[n].toLowerCase().startsWith("-d")) {
                debug = true;
                ++n;
            }
        } else {
            throw new IPException("Missing arguments in command line");
        }
        prologStartCommand = ListenerWindow.remainingArgs(stringArray, n);
    }

    public static void commonGreeting() {
        System.out.println("Welcome " + System.getProperty("user.name") + " to InterProlog " + "2.03" + " on Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + "), " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
    }

    public static String commandArgs(String[] stringArray) {
        return ListenerWindow.remainingArgs(stringArray, 0);
    }

    public static String remainingArgs(String[] stringArray, int n) {
        if (stringArray.length == 0) {
            throw new IPException("Missing arguments in command line");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < stringArray.length) {
            if (n2 > n) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class LoadedFile {
        File file;
        String method;

        LoadedFile(File file, String string) {
            this.file = file;
            this.method = string;
            if (!string.equals("reconsult") && !string.equals("load_dyn")) {
                throw new IPException("bad load method");
            }
        }

        public boolean equals(LoadedFile loadedFile) {
            return this.file.equals(loadedFile.file) && this.method.equals(loadedFile.method);
        }
    }

    class HistoryListener
    implements ActionListener {
        JTextComponent targetText;
        String memory;

        HistoryListener(JTextComponent jTextComponent, String string) {
            this.targetText = jTextComponent;
            this.memory = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.targetText.replaceSelection(this.memory);
        }
    }
}

