/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AllTests;
import com.declarativa.interprolog.PrologEngineTest;
import com.declarativa.interprolog.PrologOutputListener;
import com.declarativa.interprolog.SubprocessEngine;
import junit.framework.Assert;

public class SubprocessEngineTest
extends PrologEngineTest {
    StringBuffer buffer;

    public SubprocessEngineTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.engine = new SubprocessEngine(AllTests.xsbStartCommand());
        System.out.println("SubprocessEngineTest version:" + this.engine.getPrologVersion());
        this.thisID = this.engine.registerJavaObject((Object)this);
        this.loadTestFile();
        this.engine.waitUntilAvailable();
    }

    protected void tearDown() throws Exception {
        this.engine.shutdown();
    }

    public void testDeterministicGoal() {
        super.testDeterministicGoal();
    }

    public void testManyEngines() {
        SubprocessEngine[] subprocessEngineArray = new SubprocessEngine[2];
        int n = 0;
        while (n < subprocessEngineArray.length) {
            subprocessEngineArray[n] = new SubprocessEngine(AllTests.xsbStartCommand());
            ++n;
        }
        int n2 = 0;
        while (n2 < subprocessEngineArray.length) {
            Assert.assertTrue((boolean)subprocessEngineArray[n2].isAvailable());
            ++n2;
        }
        int n3 = 0;
        while (n3 < subprocessEngineArray.length) {
            subprocessEngineArray[n3].shutdown();
            ++n3;
        }
    }

    public void testOutputListening() {
        this.buffer = new StringBuffer();
        PrologOutputListener prologOutputListener = new PrologOutputListener(){

            public void print(String string) {
                SubprocessEngineTest.this.buffer.append(string);
            }
        };
        Assert.assertEquals((int)0, (int)((SubprocessEngine)this.engine).listeners.size());
        ((SubprocessEngine)this.engine).addPrologOutputListener(prologOutputListener);
        Assert.assertEquals((int)1, (int)((SubprocessEngine)this.engine).listeners.size());
        this.engine.deterministicGoal("write('hello,'), write(' tester'), nl");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.toString());
        }
        Assert.assertTrue((String)"printed something", (this.buffer.toString().indexOf("hello, tester") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"available", (boolean)this.engine.isAvailable());
        Assert.assertTrue((String)"detecting regular and break prompts", (boolean)((SubprocessEngine)this.engine).isDetectingPromptAndBreak());
        this.engine.command("thisIsUndefined");
        this.engine.waitUntilAvailable();
        this.engine.waitUntilAvailable();
        ((SubprocessEngine)this.engine).removePrologOutputListener(prologOutputListener);
        Assert.assertEquals((int)0, (int)((SubprocessEngine)this.engine).listeners.size());
    }
}

