/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.PrologOutputListener;
import com.declarativa.interprolog.util.GoalFromJava;
import com.declarativa.interprolog.util.GoalToExecute;
import com.declarativa.interprolog.util.IPAbortedException;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.declarativa.interprolog.util.OutputHandler;
import com.declarativa.interprolog.util.OutputListener;
import com.declarativa.interprolog.util.PrologOutputObjectStream;
import com.declarativa.interprolog.util.Recognizer;
import com.declarativa.interprolog.util.RecognizerListener;
import com.declarativa.interprolog.util.ResultFromProlog;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class SubprocessEngine
extends PrologEngine {
    Process prolog;
    PrintWriter prologStdin;
    OutputHandler stdoutHandler;
    OutputHandler stderrHandler;
    ServerSocket serverSocket;
    protected Socket socket;
    ServerSocket intServerSocket = null;
    Socket intSocket = null;
    String interruptCommand = null;
    Vector listeners = new Vector();
    boolean available;
    Recognizer promptTrigger = new Recognizer("| ?-");
    Recognizer breakTrigger = new Recognizer(": ?-");
    private RecognizerListener errorHandler = null;
    Recognizer errorTrigger = new Recognizer("++Error", true);
    private String abortMessage;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$com$declarativa$interprolog$SubprocessEngine;

    public synchronized void addPrologOutputListener(PrologOutputListener prologOutputListener) {
        ClientRecognizer clientRecognizer = new ClientRecognizer(prologOutputListener);
        this.listeners.addElement(clientRecognizer);
        this.addPrologStdoutListener(clientRecognizer);
        this.addPrologStderrListener(clientRecognizer);
    }

    public synchronized void removePrologOutputListener(PrologOutputListener prologOutputListener) {
        int n = 0;
        while (n < this.listeners.size()) {
            ClientRecognizer clientRecognizer = (ClientRecognizer)this.listeners.elementAt(n);
            if (clientRecognizer.client == prologOutputListener) {
                this.listeners.removeElementAt(n);
                this.removePrologStdoutListener(clientRecognizer);
                this.removePrologStderrListener(clientRecognizer);
            }
            ++n;
        }
    }

    public void addPrologStdoutListener(OutputListener outputListener) {
        this.stdoutHandler.addOutputListener(outputListener);
    }

    public void addPrologStderrListener(OutputListener outputListener) {
        this.stderrHandler.addOutputListener(outputListener);
    }

    public void removePrologStdoutListener(OutputListener outputListener) {
        this.stdoutHandler.removeOutputListener(outputListener);
    }

    public void removePrologStderrListener(OutputListener outputListener) {
        this.stderrHandler.removeOutputListener(outputListener);
    }

    public SubprocessEngine(String string, boolean bl) {
        super(string, bl);
        Object object;
        if (System.getProperty("java.version").compareTo("1.3") >= 0) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (SubprocessEngine.this.prolog != null) {
                        SubprocessEngine.this.prolog.destroy();
                    }
                }
            });
        } else {
            try {
                object = (class$java$lang$System == null ? (class$java$lang$System = SubprocessEngine.class$("java.lang.System")) : class$java$lang$System).getMethod("runFinalizersOnExit", Boolean.TYPE);
                ((Method)object).invoke(null, new Boolean(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object = new RecognizerListener(){

                public void recognized(Recognizer recognizer, Object object) {
                    SubprocessEngine.this.available = true;
                }
            };
            this.promptTrigger.addRecognizerListener((RecognizerListener)object);
            this.breakTrigger.addRecognizerListener((RecognizerListener)object);
            this.progressMessage("Launching subprocess " + string);
            this.prolog = Runtime.getRuntime().exec(string);
            this.stdoutHandler = new OutputHandler(this.prolog.getInputStream());
            this.stderrHandler = new OutputHandler(this.prolog.getErrorStream());
            this.setDetectPromptAndBreak(true);
            this.stdoutHandler.start();
            this.stderrHandler.start();
            Thread.yield();
            this.prologStdin = new PrintWriter(this.prolog.getOutputStream());
            this.progressMessage("Loading initial files...");
            this.command("assert(library_directory('" + this.tempDirectory.getAbsolutePath() + "'))");
            this.consultFromPackage("interprolog", class$com$declarativa$interprolog$SubprocessEngine == null ? (class$com$declarativa$interprolog$SubprocessEngine = SubprocessEngine.class$("com.declarativa.interprolog.SubprocessEngine")) : class$com$declarativa$interprolog$SubprocessEngine);
            String string2 = "127.0.0.1";
            this.progressMessage("Allocating the ServerSocket...");
            this.serverSocket = new ServerSocket(0);
            this.progressMessage("server port:" + this.serverSocket.getLocalPort());
            this.command("ipinitialize('" + string2 + "'," + this.serverSocket.getLocalPort() + "," + this.registerJavaObject(this) + "," + bl + ")");
            this.progressMessage("Waiting for the socket to accept...");
            this.socket = this.serverSocket.accept();
            this.progressMessage("Teaching examples to XSB...");
            PrologOutputObjectStream prologOutputObjectStream = new PrologOutputObjectStream(this.socket.getOutputStream());
            ObjectOutputStream objectOutputStream = prologOutputObjectStream.getObjectStream();
            this.teachIPobjects(objectOutputStream);
            this.teachBasicObjects(objectOutputStream);
            prologOutputObjectStream.flush();
            if (SubprocessEngine.isWindowsOS()) {
                this.prepareInterrupt(string2);
            }
            this.setupCallbackServer();
            this.waitUntilAvailable();
            if (!SubprocessEngine.isWindowsOS()) {
                this.prepareInterrupt(string2);
            }
        }
        catch (IOException iOException) {
            throw new IPException("Could not launch XSB:" + iOException);
        }
    }

    public SubprocessEngine(String string) {
        this(string, false);
    }

    public boolean isAvailable() {
        return this.available;
    }

    protected void setupCallbackServer() {
        Thread thread = new Thread(){

            public void run() {
                block3: {
                    try {
                        while (!SubprocessEngine.this.shutingDown) {
                            SubprocessEngine.this.progressMessage("Waiting to receive object");
                            Object object = SubprocessEngine.this.receiveObject();
                            SubprocessEngine.this.progressMessage("Received object:" + object);
                            Object object2 = SubprocessEngine.this.handleCallback(object);
                            SubprocessEngine.this.progressMessage("Handled object and computed:" + object2);
                            if (object2 == null) continue;
                            SubprocessEngine.this.sendObject(object2);
                        }
                    }
                    catch (IOException iOException) {
                        if (SubprocessEngine.this.shutingDown) break block3;
                        throw new IPException("Bad exception in setupCallbackServer:" + iOException);
                    }
                }
            }
        };
        this.progressMessage("Starting up callback service...");
        thread.setName("IP javaMessage handler");
        thread.start();
    }

    protected Object receiveObject() throws IOException {
        this.progressMessage("entering receiveObject()");
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = classNotFoundException;
        }
        this.progressMessage("exiting receiveObject():" + object);
        return object;
    }

    protected void sendObject(Object object) throws IOException {
        this.progressMessage("entering sendObject(" + object + ")");
        PrologOutputObjectStream prologOutputObjectStream = new PrologOutputObjectStream(this.socket.getOutputStream());
        prologOutputObjectStream.writeObject(object);
        prologOutputObjectStream.flush();
        this.progressMessage("exiting sendObject(" + object + ")");
    }

    public synchronized void shutdown() {
        this.shutingDown = true;
        this.available = false;
        this.stdoutHandler.setIgnoreStreamEnd(true);
        this.stderrHandler.setIgnoreStreamEnd(true);
        try {
            this.socket.close();
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            throw new IPException("Problems closing sockets:" + iOException);
        }
        if (this.isWindowsOS()) {
            try {
                try {
                    this.intSocket.close();
                    this.intServerSocket.close();
                }
                catch (IOException iOException) {
                    throw new IPException("Problems closing sockets:" + iOException);
                }
                Object var3_3 = null;
                this.prolog.destroy();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.prolog.destroy();
                throw throwable;
            }
        }
    }

    protected boolean isShutingDown() {
        return this.shutingDown;
    }

    protected void finalize() throws Throwable {
        if (this.prolog != null) {
            this.prolog.destroy();
        }
    }

    protected void setDetectPromptAndBreak(boolean bl) {
        if (bl == this.isDetectingPromptAndBreak()) {
            return;
        }
        if (bl) {
            this.stdoutHandler.addOutputListener(this.promptTrigger);
            this.stdoutHandler.addOutputListener(this.breakTrigger);
        } else {
            this.stdoutHandler.removeOutputListener(this.promptTrigger);
            this.stdoutHandler.removeOutputListener(this.breakTrigger);
        }
    }

    protected boolean isDetectingPromptAndBreak() {
        return this.stdoutHandler.hasListener(this.promptTrigger) && this.stdoutHandler.hasListener(this.breakTrigger);
    }

    public synchronized void sendAndFlush(String string) {
        this.available = false;
        this.prologStdin.print(string);
        this.prologStdin.flush();
    }

    public void sendAndFlushLn(String string) {
        this.sendAndFlush(string + PrologEngine.nl);
    }

    protected static boolean isWindowsOS() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    protected void prepareInterrupt(String string) throws IOException {
        if (SubprocessEngine.isWindowsOS()) {
            this.intServerSocket = new ServerSocket(0);
            this.command("setupWindowsInterrupt('" + string + "'," + this.intServerSocket.getLocalPort() + ")");
            this.intSocket = this.intServerSocket.accept();
        } else {
            this.waitUntilAvailable();
            Object[] objectArray = this.deterministicGoal("getPrologPID(N), ipObjectSpec('java.lang.Integer',Integer,[N],_)", "[Integer]");
            if (objectArray != null) {
                this.interruptCommand = "/bin/kill -s INT " + objectArray[0];
            } else {
                throw new IPException("Could not find XSB's PID");
            }
        }
    }

    protected synchronized void doInterrupt() {
        this.setDetectPromptAndBreak(true);
        try {
            if (SubprocessEngine.isWindowsOS()) {
                byte[] byArray = new byte[]{3};
                this.progressMessage("Attempting to interrupt XSB...");
                OutputStream outputStream = this.intSocket.getOutputStream();
                outputStream.write(byArray);
                outputStream.flush();
            } else {
                this.progressMessage("Interrupting XSB with " + this.interruptCommand);
                Runtime.getRuntime().exec(this.interruptCommand);
            }
        }
        catch (IOException iOException) {
            throw new IPException("Exception in interrupt():" + iOException);
        }
        this.waitUntilAvailable();
        this.sendAndFlushLn("abort.");
        this.waitUntilAvailable();
    }

    protected boolean realCommand(String string) {
        this.progressMessage("COMMAND:" + string + ".");
        this.sendAndFlushLn(string + ".");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] deterministicGoal(String string, String string2, Object[] objectArray, String string3) {
        boolean bl = false;
        SubprocessEngine subprocessEngine = this;
        synchronized (subprocessEngine) {
            if (!this.topGoalHasStarted) {
                this.topGoalHasStarted = true;
                bl = true;
            }
        }
        if (bl) {
            if (!this.isIdle()) {
                throw new IPException("Inconsistency in deterministicGoal:");
            }
            Object[] objectArray2 = this.firstGoal(string, string2, objectArray, string3);
            return objectArray2;
        }
        return super.deterministicGoal(string, string2, objectArray, string3);
    }

    protected Object[] firstGoal(String string, String string2, Object[] objectArray, String string3) {
        int n = this.incGoalTimestamp();
        GoalFromJava goalFromJava = this.makeDGoalObject(string, string2, objectArray, string3, n);
        Object[] objectArray2 = null;
        try {
            this.progressMessage("Schedulling (first) goal " + string + ", timestamp " + n + " in thread " + Thread.currentThread().getName());
            GoalToExecute goalToExecute = new GoalToExecute(goalFromJava);
            goalToExecute.setFirstGoalStatus();
            this.scheduleGoal(goalToExecute);
            goalToExecute.prologWasCalled();
            this.pushDGthread(goalToExecute.getCallerThread());
            this.sendObject(goalFromJava);
            this.realCommand("deterministicGoal");
            ResultFromProlog resultFromProlog = goalToExecute.waitForResult();
            this.progressMessage("got dG result for timestamp " + n);
            if (resultFromProlog == null) {
                throw new IPException("Problems in goal result");
            }
            if (goalToExecute.wasAborted()) {
                throw new IPAbortedException(string + " was aborted");
            }
            if (goalToExecute.wasInterrupted()) {
                throw new IPInterruptedException(string + " was interrupted");
            }
            if (resultFromProlog.error != null) {
                throw new IPException(resultFromProlog.error);
            }
            if (resultFromProlog.timestamp != n) {
                throw new IPException("bad timestamp in deterministicGoal, got " + resultFromProlog.timestamp + " instead of " + this.goalTimestamp);
            }
            if (resultFromProlog.succeeded) {
                objectArray2 = resultFromProlog.rVars;
            }
        }
        catch (IPException iPException) {
            throw iPException;
        }
        catch (Exception exception) {
            throw new IPException("Problem in deterministicGoal:" + exception);
        }
        finally {
            this.topGoalHasStarted = false;
            this.progressMessage("Leaving firstGoal for " + string + ", timestamp " + n + " isIdle()==" + this.isIdle());
        }
        return objectArray2;
    }

    protected Object doSomething() {
        if (this.onlyFirstGoalSchedulled()) {
            return null;
        }
        return super.doSomething();
    }

    protected synchronized boolean onlyFirstGoalSchedulled() {
        return this.isIdle() || this.messagesExecuting.size() == 0 && this.goalsToExecute.size() == 1 && ((GoalToExecute)this.goalsToExecute.elementAt(0)).isFirstGoal();
    }

    protected void setupErrorHandling() {
        this.setDetectPromptAndBreak(false);
        this.stderrHandler.addOutputListener(this.errorTrigger);
        this.abortMessage = "";
        final Thread thread = Thread.currentThread();
        this.errorHandler = new RecognizerListener(){

            public void recognized(Recognizer recognizer, Object object) {
                SubprocessEngine.this.abortMessage = (String)object;
                thread.interrupt();
            }
        };
        this.errorTrigger.addRecognizerListener(this.errorHandler);
    }

    protected void removeErrorHandling() {
        this.errorTrigger.removeRecognizerListener(this.errorHandler);
        this.stderrHandler.removeOutputListener(this.errorTrigger);
        this.errorHandler = null;
        this.setDetectPromptAndBreak(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ClientRecognizer
    extends Recognizer
    implements RecognizerListener {
        PrologOutputListener client;

        ClientRecognizer(PrologOutputListener prologOutputListener) {
            this.client = prologOutputListener;
            this.addRecognizerListener(this);
        }

        public void recognized(Recognizer recognizer, Object object) {
            this.client.print((String)object);
        }
    }
}

