/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.AllTests;
import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.TermModel;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.VariableNode;
import java.awt.Container;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JFrame;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class PrologEngineTest
extends TestCase {
    public PrologEngine engine = null;
    protected int thisID;
    static final float SMALL_FLOAT_VALUE = -3.14159f;
    static final float LARGE_FLOAT_VALUE = 8173000.0f;
    static /* synthetic */ Class class$com$declarativa$interprolog$PrologEngine;

    public PrologEngineTest(String string) {
        super(string);
    }

    public void loadTestFile() {
        this.engine.consultFromPackage("tests", class$com$declarativa$interprolog$PrologEngine == null ? (class$com$declarativa$interprolog$PrologEngine = PrologEngineTest.class$("com.declarativa.interprolog.PrologEngine")) : class$com$declarativa$interprolog$PrologEngine);
    }

    public void testNumbers() {
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[]{NumberTypes.example()};
        this.engine.teachMoreObjects(objectExamplePairArray);
        this.engine.waitUntilIdle();
        String string = "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Min,[";
        string = string + "-128,-3.14159,-134217728,-32768],_), ";
        string = string + "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$NumberTypes',Max,[";
        string = string + "127,8173000.0,134217727,32767],_)";
        NumberTypes numberTypes = new NumberTypes(-128, Short.MIN_VALUE, -134217728, -3.14159f);
        NumberTypes numberTypes2 = new NumberTypes(127, Short.MAX_VALUE, 0x7FFFFFF, 8173000.0f);
        Object[] objectArray = new Object[]{numberTypes, numberTypes2};
        Assert.assertTrue((String)"Numbers well sent", (boolean)this.engine.deterministicGoal(string, "[Min,Max]", objectArray));
        Object[] objectArray2 = this.engine.deterministicGoal(string, "[Min,Max]");
        Assert.assertEquals((String)"MIN arrived well", (Object)numberTypes, (Object)objectArray2[0]);
        Assert.assertEquals((String)"MAX arrived well", (Object)numberTypes2, (Object)objectArray2[1]);
    }

    public void testPrototypeStuff() {
        this.engine.teachOneObject(new MyClass());
        String string = "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$MyClass',[one=1,two=2],Obj)";
        string = string + ", ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$MyClass',[one=One,two=Two],Obj), Three is One+Two, ";
        string = string + "ipObjectSpec('java.lang.Integer',[value=Three],Integer)";
        Object[] objectArray = this.engine.deterministicGoal(string, "[Obj,Integer]");
        MyClass myClass = (MyClass)objectArray[0];
        Assert.assertTrue((1 == myClass.one ? 1 : 0) != 0);
        Assert.assertTrue((2 == myClass.two ? 1 : 0) != 0);
        Assert.assertEquals((Object)new Integer(3), (Object)objectArray[1]);
    }

    public void testAutoTermModel() {
        Object[] objectArray = this.engine.deterministicGoal("X=1,Y=hello(complex(term))", null);
        Assert.assertEquals((int)objectArray.length, (int)1);
        Assert.assertTrue((boolean)(objectArray[0] instanceof TermModel));
    }

    public void testBuildTermModel() {
        TermModel termModel = (TermModel)this.engine.deterministicGoal("buildTermModel(a(b,c(1)),Model)", "[Model]")[0];
        Assert.assertEquals((String)"a(b,c(1))", (String)termModel.toString());
        Assert.assertEquals((String)"a(_,_)", (String)termModel.getTemplate());
        Assert.assertEquals((int)2, (int)termModel.getChildCount());
        TermModel termModel2 = (TermModel)this.engine.deterministicGoal("buildTermModel(a(X,c(X)),Model)", "[Model]")[0];
        TermModel termModel3 = (TermModel)termModel2.getChild(0);
        Assert.assertTrue((String)"Child is var", (boolean)termModel3.isVar());
        Object object = termModel2.clone();
        Assert.assertEquals((String)termModel2.toString(), (String)object.toString());
        termModel2.assignToVar((VariableNode)termModel3.node, "someX");
        Assert.assertEquals((String)"a(someX,c(someX))", (String)termModel2.toString());
        Object[] objectArray = new Object[]{termModel2, object};
        String string = "recoverTermModel(Model3,T3), arg(1,T3,X), arg(2,T3,c(XX)), XX==X, recoverTermModel(Model2,T2), T2=T3, ";
        string = string + "arg(1,T2,someX), functor(T2,F,N), ipObjectSpec('java.lang.Integer',Integer,[N],_)";
        Object[] objectArray2 = this.engine.deterministicGoal(string, "[Model2,Model3]", objectArray, "[string(F),Integer]");
        Assert.assertTrue((objectArray2 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"a", (Object)objectArray2[0]);
        Assert.assertEquals((Object)new Integer(2), (Object)objectArray2[1]);
    }

    public void testDeterministicGoal() {
        this.engine.command("import append/3,length/2 from basics");
        this.engine.waitUntilAvailable();
        Object[] objectArray = new Object[]{new Float(16.25), new Float(0.0), new Float(15.5)};
        Object[] objectArray2 = this.engine.deterministicGoal("append([97,98],[99,100],L), length(L,N), ipObjectSpec('java.lang.Integer',Integer,[N],_), name(A,L),assert(foofoo(Objects))", "Objects", objectArray, "[Integer,string(A)]");
        Assert.assertTrue((String)"Got a result", (objectArray2 != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"First result", (Object)objectArray2[0], (Object)new Integer(4));
        Assert.assertEquals((String)"Second result", (Object)objectArray2[1], (Object)"abcd");
        Object[] objectArray3 = this.engine.deterministicGoal("foofoo([F1,F2,F3])", "[F1,F2,F3]");
        Assert.assertTrue((String)"succeeded", (objectArray3 != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)objectArray3[0], (Object)new Float(16.25));
        Assert.assertEquals((Object)objectArray3[1], (Object)new Float(0.0));
        Assert.assertEquals((String)"Third float OK", (Object)objectArray3[2], (Object)new Float(15.5));
        Assert.assertTrue((boolean)this.engine.deterministicGoal("true"));
        try {
            this.engine.deterministicGoal("foofoo(BadThingCausingGrammarFailure)", "[BadThingCausingGrammarFailure]");
            Assert.fail((String)"should raise an IPException due to grammar failure");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should complain about spec. of result bindings:" + iPException), (iPException.toString().indexOf("bindings") != -1 ? 1 : 0) != 0);
        }
        try {
            this.engine.deterministicGoal("bad goal");
            Assert.fail((String)"should raise an IPException with syntax error");
        }
        catch (IPException iPException) {
            Assert.assertTrue((String)("IPException should denote syntax error:" + iPException), (iPException.toString().indexOf("Syntax") != -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Engine ready2", (boolean)this.engine.isIdle());
        Assert.assertTrue((String)"Engine working", (boolean)this.engine.deterministicGoal("true"));
        try {
            this.engine.deterministicGoal("true", "BadResultsList");
            Assert.fail((String)"should raise an IPException complaining about lack of a Prolog list");
        }
        catch (IPException iPException) {
            // empty catch block
        }
        Assert.assertTrue((String)"Engine ready1", (boolean)this.engine.isIdle());
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(objectArray);
        vector.addElement("Hello there");
        int n = 0;
        while (n < 30) {
            Vector<Integer> vector2 = new Vector<Integer>();
            int n2 = 0;
            while (n2 < 100) {
                vector2.addElement(new Integer(n2));
                ++n2;
            }
            vector.addElement(vector2);
            ++n;
        }
        Assert.assertTrue((boolean)this.engine.deterministicGoal("import streamContents/4 from interprolog"));
        this.engine.waitUntilAvailable();
        long l = System.currentTimeMillis();
        this.engine.command("import ground/1, length/2, append/3 from basics");
        Object[] objectArray4 = new Object[]{vector};
        String string = "streamContents([Object],handles(NH,_),Bytes,[]), length(Bytes,NB), ";
        string = string + "ipObjectSpec('java.lang.Integer',IntegerNH,[NH],_), ipObjectSpec('java.lang.Integer',IntegerNB,[NB],_)";
        Object[] objectArray5 = this.engine.deterministicGoal(string, "[Object]", objectArray4, "[Object,IntegerNH,IntegerNB]");
        long l2 = System.currentTimeMillis() - l;
        int n3 = (Integer)objectArray5[2];
        System.out.println("Bulk torture took " + l2 + " mS (" + (long)(1000 * n3) / l2 + " bytes gone and returned / second)");
        Assert.assertEquals((Object)new Integer(3072), (Object)objectArray5[1]);
        if (System.getProperty("java.version").compareTo("1.4.2") >= 0) {
            Assert.assertEquals((Object)new Integer(32874), (Object)objectArray5[2]);
        } else {
            Assert.assertEquals((Object)new Integer(32843), (Object)objectArray5[2]);
        }
        Assert.assertTrue((boolean)(objectArray5[0] instanceof Vector));
        l = System.currentTimeMillis();
        int n4 = 3;
        int n5 = 0;
        while (n5 < n4) {
            Assert.assertTrue((boolean)this.engine.deterministicGoal("true"));
            ++n5;
        }
        System.out.println("Busy torture took " + (System.currentTimeMillis() - l) / (long)n4 + " mS/goal");
    }

    public void testDG2() {
        String string = "(X=a;X=b)";
        String string2 = "X";
        String string3 = "findall(TM, (" + string + ",buildTermModel(" + string2 + ",TM)), L), ipObjectSpec('ArrayOfObject',L,LM)";
        Object[] objectArray = (Object[])this.engine.deterministicGoal(string3, "[LM]")[0];
        Assert.assertEquals((int)2, (int)objectArray.length);
        Assert.assertEquals((String)"a", (String)objectArray[0].toString());
    }

    public int luckyNumber() {
        return 13;
    }

    public void testJavaMessage() {
        Assert.assertEquals((int)this.engine.registerJavaObject((Object)this), (int)this.thisID);
        String string = "javaMessage(" + this.thisID + ",R,luckyNumber), ipObjectSpec('java.lang.Integer',R,[13],_)";
        Assert.assertTrue((String)"Succeeded 1st", (boolean)this.engine.deterministicGoal(string));
        String string2 = "assert((tortureJM(0) :- !)), ";
        string2 = string2 + "assert((tortureJM(N) :- NN is N-1, " + string + ", tortureJM(NN)))";
        Assert.assertTrue((String)"Succeeded 2nd", (boolean)this.engine.deterministicGoal(string2));
        long l = System.currentTimeMillis();
        int n = 10;
        Assert.assertTrue((String)"Succeeded torture", (boolean)this.engine.deterministicGoal("tortureJM(" + n + ")"));
        System.out.println("Callback torture took " + (System.currentTimeMillis() - l) / (long)n + " mS/message");
    }

    public void testIPobjects() {
        Assert.assertTrue((boolean)this.engine.deterministicGoal("import length/2 from basics"));
        String string = "findall(foo,ipObjectSpec(_,_,_,_), L), length(L,_N), ";
        string = string + "findall(foo,ipObjectTemplate(_,_,_,_,_), LL), length(LL,_N), ";
        string = string + "ipObjectSpec('java.lang.Integer',Integer,[_N],_) ";
        Integer n = (Integer)this.engine.deterministicGoal(string, "[Integer]")[0];
        Assert.assertTrue((n > 20 ? 1 : 0) != 0);
    }

    public void testXSBstuff() {
        this.engine.teachOneObject(new ConfigurationItem());
        String string = "F=install_dir, findall(Obj, (xsb_configuration(F,V), ";
        string = string + "ipObjectSpec('com.declarativa.interprolog.PrologEngineTest$ConfigurationItem',[feature=string(F),value=string(V)],Obj)";
        string = string + "),L), ipObjectSpec('ArrayOfObject',L,Array)";
        Object[] objectArray = (Object[])this.engine.deterministicGoal(string, "[Array]")[0];
        ConfigurationItem configurationItem = (ConfigurationItem)objectArray[0];
        Assert.assertTrue((AllTests.xsbStartCommand().indexOf(configurationItem.value) != -1 ? 1 : 0) != 0);
    }

    public void testLoops() {
        Loop loop;
        this.engine.teachOneObject(new Loop());
        loop.next = loop = new Loop();
        Assert.assertTrue((boolean)this.engine.deterministicGoal("true", "[L]", new Object[]{loop}));
    }

    public int somaN(int n) {
        Object[] objectArray = this.engine.deterministicGoal("somaN(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testSomaN() {
        this.engine.waitUntilIdle();
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipSomaN(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("somaN(10,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(55));
    }

    public int fibonaci(int n) {
        Object[] objectArray = this.engine.deterministicGoal("fib(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testFibonaci() {
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipFibonaci(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("fib(10,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(89));
    }

    public int factorial(int n) {
        Object[] objectArray = this.engine.deterministicGoal("fac(" + n + ",X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        return (Integer)objectArray[0];
    }

    public void testFactorial() {
        this.engine.command("ipObjectSpec('InvisibleObject',_T,[" + this.thisID + "],_)," + "assert(ipFactorial(_T))");
        this.engine.waitUntilIdle();
        Object[] objectArray = this.engine.deterministicGoal("fac(7,X), ipObjectSpec('java.lang.Integer',Spec,[X],_)", "[Spec]");
        Integer n = (Integer)objectArray[0];
        Assert.assertTrue((String)"Got a result", (objectArray != null ? 1 : 0) != 0);
        this.engine.progressMessage("result: " + objectArray[0]);
        Assert.assertEquals((String)"First result", (Object)n, (Object)new Integer(5040));
    }

    public TermModel[] someTerms() {
        return new TermModel[]{new TermModel("a"), new TermModel("b")};
    }

    public void testGetRealJavaObject() {
        String string = "javaMessage(" + this.thisID + ",Tref,someTerms), ";
        string = string + "ipPrologEngine(E), javaMessage(E,Obj,getRealJavaObject(Tref)), recoverTermModelArray(Obj,[a,b])";
        Assert.assertTrue((boolean)this.engine.deterministicGoal(string));
    }

    public void testStrangeChar() {
        Assert.assertEquals((Object)new String(new char[]{'\u0080'}), (Object)this.engine.deterministicGoal("name(CircleR,[128])", "[string(CircleR)]")[0]);
        Assert.assertTrue((String)new String(new char[]{'\u00e7'}), (this.engine.deterministicGoal("name(CircleR,[231])", "[string(CircleR)]") != null ? 1 : 0) != 0);
    }

    public void testBlockdataSerialization1() {
        Object[] objectArray = new Object[]{new Container()};
        Object[] objectArray2 = this.engine.deterministicGoal("true", "[W]", objectArray, "[W]");
        Container container = (Container)objectArray2[0];
    }

    public void testBlockdataSerialization2() {
        Object[] objectArray = new Object[]{new JFrame("My window")};
        Object[] objectArray2 = this.engine.deterministicGoal("true", "[W]", objectArray, "[]");
        Assert.assertTrue((objectArray2 != null ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Loop
    implements Serializable {
        Loop next;
    }

    public static class ConfigurationItem
    implements Serializable {
        String feature;
        String value;

        public String toString() {
            return "FEATURE " + this.feature + " HAS VALUE " + this.value;
        }
    }

    public static class MyClass
    implements Serializable {
        int one = 0;
        int two = 0;
    }

    public static class NumberTypes
    implements Serializable {
        byte b;
        short s;
        int i;
        float f;

        public NumberTypes(byte by, short s, int n, float f) {
            this.b = by;
            this.s = s;
            this.i = n;
            this.f = f;
        }

        public static ObjectExamplePair example() {
            return new ObjectExamplePair(new NumberTypes(-128, Short.MIN_VALUE, -134217728, -3.14159f), (Object)new NumberTypes(127, Short.MAX_VALUE, 0x7FFFFFF, 8173000.0f));
        }

        public String toString() {
            return "b==" + this.b + ",s==" + this.s + ",i==" + this.i + ",f==" + this.f;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NumberTypes)) {
                return false;
            }
            NumberTypes numberTypes = (NumberTypes)object;
            return numberTypes.b == this.b && numberTypes.s == this.s && numberTypes.i == this.i && numberTypes.f == this.f;
        }
    }
}

