/*
 * Decompiled with CFR 0.152.
 */
package com.xsb.interprolog;

import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.gui.ListenerWindow;
import com.declarativa.interprolog.util.IPAbortedException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.xsb.interprolog.NativeEngine;
import javax.swing.SwingUtilities;

public class NativeEngineWindow
extends ListenerWindow {
    public NativeEngineWindow(NativeEngine nativeEngine) {
        this(nativeEngine, true);
        this.setTitle("NativeEngine listener (" + nativeEngine.getPrologVersion() + ")");
    }

    public NativeEngineWindow(NativeEngine nativeEngine, boolean bl) {
        super(nativeEngine, bl);
        this.prologInput.setToolTipText("Prolog goal, sent when you press enter. Drag and drop .P files here to reconsult them");
        this.prologOutput.setToolTipText("Goals and their first solutions");
    }

    public void sendToProlog() {
        String string = this.prologInput.getText().trim();
        if (string.equals(";")) {
            ListenerWindow.beep();
            this.prologOutput.append("Sorry, no multiple solutions available with NativeEngine; use SubprocessEngine if you need them\n");
            return;
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            ListenerWindow.beep();
            this.prologOutput.append("Goal must be nonempty\n");
            return;
        }
        final String string2 = string;
        this.prologOutput.append(string2 + "\n");
        this.addToHistory();
        Thread thread = new Thread(){
            String result;

            public void run() {
                try {
                    Object[] objectArray = NativeEngineWindow.this.engine.deterministicGoal(string2, null);
                    this.result = NativeEngineWindow.this.formatGoalResult(objectArray);
                }
                catch (IPInterruptedException iPInterruptedException) {
                    this.result = "Goal was interrupted!";
                }
                catch (IPAbortedException iPAbortedException) {
                    this.result = "Goal was aborted!";
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$000(this.this$1).prologOutput.append(this.this$1.result + "\n");
                        1.access$000(this.this$1).scrollToBottom();
                        1.access$000(this.this$1).focusInput();
                    }
                });
            }

            static /* synthetic */ NativeEngineWindow access$000(1 var0) {
                return var0.NativeEngineWindow.this;
            }
        };
        thread.setName("NativeEngineWindow command");
        thread.start();
    }

    protected String formatGoalResult(Object[] objectArray) {
        if (objectArray == null) {
            return "FAILED\n";
        }
        return objectArray[0].toString() + "\n";
    }

    public static void main(String[] stringArray) {
        ListenerWindow.commonMain(stringArray);
        if (ListenerWindow.prologStartCommand.indexOf(32) != -1) {
            System.err.println("Beware that any extra arguments in your command line will NOT");
            System.err.println("be considered by Prolog. For finer control use the NativeEngine class directly");
        }
        new NativeEngineWindow(new NativeEngine(PrologEngine.prologBinToBaseDirectory(ListenerWindow.prologStartCommand), ListenerWindow.debug));
    }
}

