/*
 * Decompiled with CFR 0.152.
 */
package com.xsb.interprolog;

import com.declarativa.interprolog.AllTests;
import com.declarativa.interprolog.PrologEngineTest;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.xsb.interprolog.NativeEngine;
import junit.framework.Assert;

public class NativeEngineTest
extends PrologEngineTest {
    boolean didInterrupt;

    public NativeEngineTest(String string) {
        super(string);
        this.engine = new NativeEngine(AllTests.xsbDir());
        System.out.println("NativeEngineTest version:" + this.engine.getPrologVersion());
        this.thisID = this.engine.registerJavaObject((Object)this);
        this.loadTestFile();
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNativeEngine() {
        this.testNewInterrupt();
        System.out.println("Ended testNewInterrupt");
        this.testNumbers();
        this.testPrototypeStuff();
        this.testAutoTermModel();
        this.testBuildTermModel();
        this.testDeterministicGoal();
        this.testDG2();
        this.testJavaMessage();
        System.out.println("Ended testJavaMessage");
        this.testIPobjects();
        this.testXSBstuff();
        this.testLoops();
        this.testSomaN();
        this.testFibonaci();
        this.testFactorial();
        System.out.println("Ended testFactorial");
        this.testMultipleThreads();
        this.testGetRealJavaObject();
        System.out.println("Ended testGetRealJavaObject");
        this.testStrangeChar();
        this.testBlockdataSerialization1();
        this.testBlockdataSerialization2();
    }

    void testNewInterrupt() {
        this.didInterrupt = false;
        Thread thread = new Thread(){

            public void run() {
                try {
                    NativeEngineTest.this.engine.deterministicGoal("repeat,fail");
                    Assert.fail((String)"should have thrown IPInterruptedException");
                }
                catch (IPInterruptedException iPInterruptedException) {
                    NativeEngineTest.this.didInterrupt = true;
                }
            }
        };
        thread.start();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engine.interrupt();
        while (!this.didInterrupt) {
            Thread.yield();
        }
        Object object = this.engine.deterministicGoal("R=string(still_alive)", "[R]")[0];
        Assert.assertEquals((Object)object, (Object)"still_alive");
    }

    public void testMultipleThreads() {
        DGClient dGClient = new DGClient("Heavenly", 10L, 10L, 10L, 10L, 50L, 50L);
        DGClient dGClient2 = new DGClient("Mount Snow", 5L, 5L, 10L, 10L, 10L, 10L);
        dGClient.start();
        dGClient2.start();
        while (dGClient.isAlive() || dGClient2.isAlive()) {
            Thread.yield();
        }
    }

    public class DGClient
    extends Thread {
        int myID;
        long T1;
        long T2;
        long T3;
        long T4;
        long T5;
        long T6;

        DGClient(String string, long l, long l2, long l3, long l4, long l5, long l6) {
            this.myID = NativeEngineTest.this.engine.registerJavaObject(this);
            this.T1 = l;
            this.T2 = l2;
            this.T3 = l3;
            this.T4 = l4;
            this.T5 = l5;
            this.T6 = l6;
            this.setName(string);
        }

        public void run() {
            try {
                Thread.sleep(this.T1);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("javaMessage(" + this.myID + ",method1)"));
                Thread.sleep(this.T2);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("javaMessage(" + this.myID + ",method1)"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }

        public void method1() {
            try {
                Thread.sleep(this.T3);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("javaMessage(" + this.myID + ",method2)"));
                Thread.sleep(this.T4);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("javaMessage(" + this.myID + ",method2)"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }

        public void method2() {
            try {
                Thread.sleep(this.T5);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("true"));
                Thread.sleep(this.T6);
                Assert.assertTrue((boolean)NativeEngineTest.this.engine.deterministicGoal("true"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
    }
}

