/*
 * Decompiled with CFR 0.152.
 */
package com.xsb.interprolog;

import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.util.IPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class NativeEngine
extends PrologEngine {
    private ByteArrayOutputStream bao = new ByteArrayOutputStream();
    static /* synthetic */ Class class$com$declarativa$interprolog$PrologEngine;

    private native void xsb_setDebug(boolean var1);

    protected native int xsb_init_internal(String var1);

    protected native int xsb_command_string(String var1);

    protected native int xsb_close_query();

    protected native int put_bytes(byte[] var1, int var2, int var3, String var4);

    protected native byte[] get_bytes();

    protected native void xsb_interrupt();

    public NativeEngine(String string) {
        this(string, false);
    }

    public NativeEngine(String string, boolean bl) {
        super(string, bl);
        if (PrologEngine.numberOfInstances > 1) {
            throw new IPException("Can't have more than one instance of NativeEngine");
        }
        int n = this.xsb_init_internal(string);
        if (n != 0) {
            throw new IPException("XSB Initialization error");
        }
        try {
            this.progressMessage("Setting up Prolog library paths...");
            this.command("assert(library_directory('" + this.tempDirectory.getAbsolutePath() + "'))");
            this.progressMessage("Loading initial file...");
            this.consultFromPackage("interprolog", class$com$declarativa$interprolog$PrologEngine == null ? (class$com$declarativa$interprolog$PrologEngine = NativeEngine.class$("com.declarativa.interprolog.PrologEngine")) : class$com$declarativa$interprolog$PrologEngine);
            this.progressMessage("Teaching examples to XSB...");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            this.teachIPobjects(objectOutputStream);
            this.teachBasicObjects(objectOutputStream);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (this.put_bytes(byArray, byArray.length, 1, "ipLearnExamples") != 0) {
                throw new IPException("ipLearnExamples failed");
            }
            this.progressMessage("Initial examples taught.");
            this.xsb_close_query();
            if (!this.command("ipObjectSpec('InvisibleObject',E,[" + this.registerJavaObject(this) + "],_), assert(ipPrologEngine(E))")) {
                throw new IPException("assert of ipPrologEngine/1 failed");
            }
            if (bl && !this.command("assert(ipIsDebugging)")) {
                throw new IPException("assert of ipIsDebugging failed");
            }
        }
        catch (Exception exception) {
            throw new IPException("Could not initialize XSB:" + exception);
        }
        this.startTopGoal();
    }

    protected void startTopGoal() {
        Thread thread = new Thread(){

            public void run() {
                boolean bl = false;
                while (!bl) {
                    NativeEngine.this.progressMessage("Calling firstJavaMessage...");
                    int n = NativeEngine.this.xsb_command_string("ipPrologEngine(E), javaMessage(E,firstJavaMessage).");
                    if (n == 1 && NativeEngine.this.interrupting) {
                        NativeEngine.this.interruptTasks();
                        continue;
                    }
                    if (n == 1) {
                        System.err.println("Prolog execution aborted and restarted");
                        NativeEngine.this.abortTasks();
                        continue;
                    }
                    bl = true;
                    System.out.println("NativeEngine ending abnormally, rc==" + n);
                }
            }
        };
        this.topGoalHasStarted = true;
        thread.setName("Prolog handler");
        thread.start();
    }

    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.xsb_setDebug(bl);
    }

    public void shutdown() {
        System.err.println("NO SHUTDOWN YET!!!");
    }

    protected void doInterrupt() {
        this.xsb_interrupt();
    }

    protected boolean realCommand(String string) {
        int n = this.xsb_command_string(string + ".");
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        throw new IPException("Problem executing Prolog command");
    }

    public Object[] deterministicGoal(String string, String string2, Object[] objectArray, String string3) {
        if (!this.topGoalHasStarted) {
            throw new IPException("Premature invocation of deterministicGoal");
        }
        return super.deterministicGoal(string, string2, objectArray, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] callback(byte[] byArray) {
        byte[] byArray2;
        Object object;
        Object object2;
        Object object3;
        this.progressMessage("entering callback(byte[])");
        try {
            object3 = new ByteArrayInputStream(byArray);
            object2 = new ObjectInputStream((InputStream)object3);
            object = ((ObjectInputStream)object2).readObject();
            ((ObjectInputStream)object2).close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = classNotFoundException;
        }
        catch (IOException iOException) {
            throw new IPException("Bad exception before callback handling:" + iOException);
        }
        object3 = this.handleCallback(object);
        try {
            object2 = this;
            synchronized (object2) {
                this.bao.reset();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.bao);
                objectOutputStream.writeObject(object3);
                objectOutputStream.flush();
                byArray2 = this.bao.toByteArray();
            }
        }
        catch (IOException iOException) {
            throw new IPException("Bad exception after callback handling:" + iOException);
        }
        return byArray2;
    }

    public boolean isIdle() {
        return super.isIdle();
    }

    public String getPrologBaseDirectory() {
        if (this.startPrologCommand.endsWith(File.separator)) {
            return this.startPrologCommand.substring(0, this.startPrologCommand.length() - 1);
        }
        return this.startPrologCommand;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.loadLibrary("xsb");
    }
}

