/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class PrologOutputObjectStream {
    OutputStream os;
    ObjectOutputStream tempObjects;
    ByteArrayOutputStream serializedTemp;
    boolean flushed = false;

    public PrologOutputObjectStream(OutputStream outputStream) throws IOException {
        this.os = outputStream;
        this.serializedTemp = new ByteArrayOutputStream();
        this.tempObjects = new ObjectOutputStream(this.serializedTemp);
    }

    public ObjectOutputStream getObjectStream() {
        return this.tempObjects;
    }

    public void flush() throws IOException {
        this.tempObjects.close();
        new DataOutputStream(this.os).writeInt(this.size());
        this.serializedTemp.writeTo(this.os);
        this.serializedTemp.close();
        this.os.flush();
        this.flushed = true;
    }

    public void writeObject(Object object) throws IOException {
        if (this.flushed) {
            throw new Error("A PrologOutputObjectStream can be used only once.");
        }
        this.tempObjects.writeObject(object);
    }

    public int size() {
        return this.serializedTemp.size();
    }
}

