/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.InvisibleObject;
import java.util.Vector;

public class ObjectRegistry {
    Vector objects = new Vector();

    public Object getRealJavaObject(InvisibleObject invisibleObject) {
        return this.getRealJavaObject(invisibleObject.ID);
    }

    public Object getRealJavaObject(int n) {
        if (n < 0 | n > this.objects.size() - 1) {
            throw new RuntimeException("Bad object ID in ObjectRegistry");
        }
        return this.objects.elementAt(n);
    }

    public Object makeInvisible(Object object) {
        return new InvisibleObject(this.registerJavaObject(object));
    }

    public synchronized int registerJavaObject(Object object) {
        if (object == null) {
            throw new IPException("Null object in ObjectRegistry");
        }
        int n = this.getObjectID(object);
        if (n >= 0) {
            return n;
        }
        this.objects.addElement(object);
        return this.objects.size() - 1;
    }

    private int getObjectID(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.objects.size()) {
                if (this.objects.elementAt(n) == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.objects.size()) {
                Object e = this.objects.elementAt(n);
                if (e != null && object.equals(e)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public synchronized boolean unregisterJavaObject(Object object) {
        int n;
        boolean bl = false;
        if (object != null && (n = this.getObjectID(object)) >= 0) {
            this.objects.setElementAt(null, n);
            bl = true;
        }
        return bl;
    }

    public synchronized boolean unregisterJavaObjects(Class clazz) {
        boolean bl = false;
        if (clazz != null) {
            String string = clazz.getName();
            int n = 0;
            while (n < this.objects.size()) {
                Object e = this.objects.elementAt(n);
                if (e != null && e.getClass().getName().equals(string)) {
                    this.objects.setElementAt(null, n);
                    bl = true;
                }
                ++n;
            }
            int n2 = this.objects.size();
            while (n2 > 0) {
                if (this.objects.elementAt(n2 - 1) != null) break;
                --n2;
            }
            this.objects.setSize(n2);
        }
        return bl;
    }
}

