/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.gui;

import com.declarativa.interprolog.gui.TermListModel;
import com.declarativa.interprolog.gui.TermModelWindow;
import com.declarativa.interprolog.gui.TermTreeModel;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TermTreePane
extends JPanel {
    JList[] lists;
    TermTreeModel model;
    Object[] levelTitles;

    TermTreePane(TermTreeModel termTreeModel, Object[] objectArray) {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        if (termTreeModel == null) {
            throw new RuntimeException("Null model in TermTreeWindow");
        }
        int n = termTreeModel.depth();
        if (n < 2) {
            throw new RuntimeException("Bad model in TermTreeWindow:" + termTreeModel);
        }
        if (objectArray == null) {
            objectArray = new String[]{};
        }
        this.levelTitles = objectArray;
        this.lists = new JList[n];
        this.model = termTreeModel;
        String[] stringArray = new String[]{"     "};
        int n2 = 0;
        while (n2 < n) {
            jComponent = new JList<String>(stringArray);
            this.lists[n2] = jComponent;
            if (n2 < n - 1) {
                ((JList)jComponent).addListSelectionListener(new ListHandler(n2));
            }
            jComponent.addMouseListener(new MouseAdapter((JList)jComponent){
                private final /* synthetic */ JList val$list;
                {
                    this.val$list = jList;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = this.val$list.locationToIndex(mouseEvent.getPoint());
                        TermListModel termListModel = (TermListModel)this.val$list.getModel();
                        if (n != -1) {
                            new TermModelWindow(termListModel.terms[n]);
                        }
                    }
                }
            });
            ++n2;
        }
        this.lists[0].setModel(termTreeModel.topList());
        if (n > 2) {
            jComponent = new JSplitPane(1, true, this.paneForList(0), this.paneForList(1));
            ((JSplitPane)jComponent).setDividerLocation(0.5);
            int n3 = 2;
            while (n3 < n - 1) {
                jComponent = new JSplitPane(1, true, jComponent, this.paneForList(n3));
                ((JSplitPane)jComponent).setDividerLocation((float)n3 / (float)(n - 1));
                ++n3;
            }
            this.add("Center", jComponent);
        } else {
            this.add("Center", this.paneForList(0));
        }
    }

    JComponent paneForList(int n) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", new JScrollPane(this.lists[n]));
        if (n > this.levelTitles.length - 2) {
            jPanel.add("North", new JLabel(" "));
        } else {
            jPanel.add("North", new JLabel(this.levelTitles[n + 1].toString()));
        }
        return jPanel;
    }

    class ListHandler
    implements ListSelectionListener {
        int position;

        ListHandler(int n) {
            this.position = n;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            if (!listSelectionEvent.getValueIsAdjusting() & jList.getSelectedIndex() != -1) {
                TermTreePane.this.lists[this.position + 1].setModel(this.findModel(this.position).topList());
                this.clearRightLists();
                this.repaintRight();
            }
        }

        void clearRightLists() {
            int n = this.position + 2;
            while (n < TermTreePane.this.lists.length) {
                TermTreePane.this.lists[n].setListData(new Object[0]);
                ++n;
            }
        }

        void repaintRight() {
            int n = this.position + 1;
            while (n < TermTreePane.this.lists.length) {
                TermTreePane.this.lists[n].repaint();
                ++n;
            }
        }

        TermTreeModel findModel(int n) {
            TermTreeModel termTreeModel = TermTreePane.this.model.children[TermTreePane.this.lists[0].getSelectedIndex()];
            int n2 = 1;
            while (n2 <= n) {
                termTreeModel = termTreeModel.children[TermTreePane.this.lists[n2].getSelectedIndex()];
                ++n2;
            }
            return termTreeModel;
        }
    }
}

