%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file 'moon.m' contains demonstration code for creating movie.

% Programmer : Tao Jin (thomasjt@temple.edu)
% Date : Oct. 2002
% Advisor : Dr.Longin Jan Latecki (latecki@temple.edu )
% Project : CIS581 Assignment 1
% Department : Computer and Information Science Department, Temple University, Philadelphia, PA-19122, USA

% Input arguments:-
% None

% Output : -
% avi file name.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [aviFileName] = MovingMoon

wholeImg = imread('moon.bmp');
totalRows = size(wholeImg,1);
totalCols = size(wholeImg,2);

%create avi file
framesPerSec = 5; % 'frames per second' parameter for the .avi file.
aviFileName = 'MovingMoon';
%aviobj = avifile(aviFileName,'fps',framesPerSec,'COMPRESSION','NONE'); % initialize .avi file object.
aviobj = avifile(aviFileName,'fps',framesPerSec); % initialize .avi file object.

%find moon in the picture
[moonOriY,moonOriX] = find(wholeImg(:,:,1)); %blackback ground picture, non-zero pixels are moon image, only find in the first matrix

%create background img, erase moon but keep earth
bkgndImg = wholeImg;
for i=1:size(moonOriX,1)
    bkgndImg(moonOriY(i), moonOriX(i), :)=0;
end

%translation from (0,0) at left top to (0,0) at center
moonOriY = (totalRows - moonOriY) - totalRows/2;
moonOriX = moonOriX - totalCols/2;

moonNewX = moonOriX;
moonNewY = moonOriY;

%moving step
base = 0;
step = (pi/180)*5;

for count=1:72 % move a circle
    tmpImg = bkgndImg; %background image
    base = base + step;
    rotMat = [cos(base), sin(base); -sin(base), cos(base)];

    %get new position for each pixel of the moon
    for i=1:size(moonOriX,1) %loop for every pixel in [moonCols(i), moonRows(i)]
        tmpVector = [moonOriX(i), moonOriY(i)];
        tmpVector =  tmpVector * rotMat;
        moonNewX(i) = int32(tmpVector(1));
        moonNewY(i) = int32(tmpVector(2));
    end
    
    %coordination translation, back to (0,0) at left top
    moonNewX = moonNewX + totalCols/2;
    moonNewY = totalRows - (moonNewY + totalRows/2);

    %merge the new moon image into the backgroud image
    for i=1:size(moonNewX,1) %loop for every pixel in [moonCols(i), moonRows(i)]
        tmpImg(moonNewY(i), moonNewX(i), :) = 255;
    end

    %save tmpImg in avi file
    imwrite(tmpImg,'tmp.bmp','bmp');
    imgObj = imread('tmp.bmp','bmp'); 
    frameObj = im2frame(imgObj);  
    aviobj = addframe(aviobj,frameObj);
   % frame(count) = frameObj;
    delete('tmp.bmp');
end
%movie(frame);
aviobj = close(aviobj);
return;