clear;
colormap('default');
image = imread('starsandstripes.bmp', 'bmp');

avi = avifile('starsandstripes.avi', 'fps', 10);
frame = im2frame(image);
avi = addframe(avi, frame);

for col = 1 : 5 : 320
  for row = 1 : 240
    for color = 1 : 3
      image(row, col, color) = uint8(255 - double(image(row, col, color)));
      image(row, col + 1, color) = uint8(255 - double(image(row, col + 1, color)));
      image(row, col + 2, color) = uint8(255 - double(image(row, col + 2, color)));
      image(row, col + 3, color) = uint8(255 - double(image(row, col + 3, color)));
      image(row, col + 4, color) = uint8(255 - double(image(row, col + 4, color)));
    end
  end
  frame = im2frame(image);
  avi = addframe(avi, frame);
end

for row = 1 : 5 : 240
  for col = 1 : 320
    for color = 1 : 3
      image(row, col, color) = uint8(255 - double(image(row, col, color)));
      image(row + 1, col, color) = uint8(255 - double(image(row + 1, col, color)));
      image(row + 2, col, color) = uint8(255 - double(image(row + 3, col, color)));
      image(row + 3, col, color) = uint8(255 - double(image(row + 3, col, color)));
      image(row + 4, col, color) = uint8(255 - double(image(row + 4, col, color)));
    end
  end
  frame = im2frame(image);
  avi = addframe(avi, frame);
end

avi = close(avi);
